/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.ar;

import com.ibm.hwmca.base.pa.event.DuplicateAnalysisCompleteEvent;
import com.ibm.hwmca.base.pa.event.SystemAnalysisCompleteEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.pa.incident.IncidentPool;
import com.ibm.hwmca.fw.pa.persist.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.pa.persist.ProblemPersistenceException;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemFilter;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.problem.ProblemNotRegisteredException;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfaces;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.ar.CommonServiceAnalysisRoutine;
import com.ibm.hwmca.xfw.pa.event.CommonDataEvent;
import com.ibm.hwmca.xfw.pa.incident.CommonServiceIncident;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DuplicateAnalysisRoutine
extends CommonServiceAnalysisRoutine
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "XPADPART";
    private static final String TRACE_MASKF = "XPADPARF";
    private static final String TRACE_MASKD = "XPADPARD";

    public DuplicateAnalysisRoutine() {
        Trace.trace(TRACE_MASKD, "<-> ctor");
    }

    public void analyze(ProblemAnalysisEvent event) {
        Trace.trace(TRACE_MASKF, "--> DuplicateAnalysisRoutine.analyze() v1.0");
        SystemAnalysisCompleteEvent ourEvent = (SystemAnalysisCompleteEvent)event;
        PASystem system = ourEvent.getSystem();
        String poolId = ourEvent.getIncidentPoolId();
        ProblemManager thePM = null;
        try {
            thePM = ProblemManager.getProblemManager();
        }
        catch (ProblemPersistenceException e) {
            Trace.trace(TRACE_MASKD, "Got an exception. Who cares!!!!");
        }
        catch (PersistenceNotInitializedException e) {
            // empty catch block
        }
        IncidentPool thePool = DuplicateAnalysisRoutine.getAnalyzingIncidentPool(poolId);
        if (thePool == null) {
            Trace.trace(TRACE_MASKT, "<-- analyze(): no pool to analyze");
            return;
        }
        Trace.trace(TRACE_MASKD, "loop through the problems we have in the pool");
        List knownProblems = thePM.getAllProblems();
        ArrayList duplicateProblems = new ArrayList();
        ArrayList tempDuplicateProblems = new ArrayList();
        ArrayList timeFilteredProblems = new ArrayList();
        String poolMachineModel = null;
        String poolMachineSerial = null;
        String poolMachineType = null;
        String poolRefCode = null;
        boolean dupProblem = false;
        Iterator poolIterator = thePool.iterator();
        while (poolIterator.hasNext()) {
            ProblemFilter dupFilter;
            CommonServiceIncident workIncident = (CommonServiceIncident)poolIterator.next();
            CommonProblem poolProblem = workIncident.getProblem();
            Trace.trace(TRACE_MASKF, "working with problem uuid of " + poolProblem.getUniqueKey());
            try {
                dupFilter = (ProblemFilter)ServiceInterfaces.getFactory(poolProblem.getFailingSystem(), "DupFilter");
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "got an exception");
                Trace.trace(TRACE_MASKF, e);
                continue;
            }
            if (dupFilter == null) continue;
            Trace.trace(TRACE_MASKF, "got a dup filter to use");
            dupFilter.setProblem(poolProblem);
            dupFilter.filter(tempDuplicateProblems, knownProblems);
            int dupCount = tempDuplicateProblems.size();
            if (dupCount > 0) {
                Trace.trace(TRACE_MASKD, "the problem is a duplicate of an exsisting one.");
                Trace.trace(TRACE_MASKD, "number=" + ((Problem)tempDuplicateProblems.get(0)).getProblemNumber() + " newLastReportedTS = " + poolProblem.getFirstReportedTimestamp() + "added to addDuplicateProblemId");
                poolProblem.setDuplicateOfProblemNumber(((Problem)tempDuplicateProblems.get(0)).getUniqueKey(), ((Problem)tempDuplicateProblems.get(0)).getProblemNumber());
                ((CommonProblem)tempDuplicateProblems.get(0)).setLastReportedTimestamp(poolProblem.getFirstReportedTimestamp());
                ((CommonProblem)tempDuplicateProblems.get(0)).addDuplicateProblemId(poolProblem.getUniqueKey());
                PASystem aSystem = poolProblem.getFailingSystem();
                poolMachineModel = aSystem.getMachineModel();
                poolMachineType = aSystem.getMachineType();
                poolMachineSerial = aSystem.getMachineSerial();
                poolRefCode = poolProblem.getRefcode();
                Trace.trace(TRACE_MASKD, "duplicate problem found for: \n uuid    : " + poolProblem.getUniqueKey() + "\n Model   : " + poolMachineModel + "\n Serial  : " + poolMachineSerial + "\n Type    : " + poolMachineType + "\n RefCode : " + poolRefCode);
                Iterator it = tempDuplicateProblems.iterator();
                while (it.hasNext()) {
                    List secondaryList;
                    Problem loopProblem = (Problem)it.next();
                    if (!(loopProblem instanceof CommonProblem)) continue;
                    CommonDataEvent cde = poolProblem.getPrimaryDataEvent();
                    if (cde != null) {
                        ((CommonProblem)loopProblem).addSecondaryDataEvent(cde);
                    }
                    if ((secondaryList = poolProblem.getSecondaryDataEventList()) == null) continue;
                    ((CommonProblem)loopProblem).addSecondaryDataEvent(secondaryList);
                }
                try {
                    thePM.changed((Problem)tempDuplicateProblems.get(0));
                }
                catch (ProblemNotRegisteredException e1) {
                    e1.printStackTrace();
                }
                catch (PersistenceNotInitializedException e1) {
                    e1.printStackTrace();
                }
                catch (ProblemPersistenceException e1) {
                    e1.printStackTrace();
                }
                continue;
            }
            Trace.trace(TRACE_MASKD, "this was not a duplicate problem open it ");
        }
        Trace.trace(TRACE_MASKF, "post a DuplicateAnalysisCompleteEvent");
        this.postServiceAREvent(new DuplicateAnalysisCompleteEvent(this), system, poolId);
        Trace.trace(TRACE_MASKF, "<-- DuplicateAnalysisRoutine.analyze()");
    }
}

